/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.summary;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.install.commons.base.interview.common.bean.Component;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.ComponentSet;
import oracle.install.commons.base.summary.Percentage;
import oracle.install.commons.base.summary.Variable;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Summary {
    public static final String PROPERTY_READY = "Summary.ready";
    private String title;
    private String description;
    private List<Category> categories = new ArrayList<Category>();
    private List<ComponentSet> componentSets = new ArrayList<ComponentSet>();
    private boolean ready;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean isSuccessfullInstall = true;
    private boolean isSuccessfullRemoteInstall = true;
    private boolean isSuccessfulConfig = true;
    private static Summary instance = null;

    private Summary() {
    }

    public static Summary getInstance() {
        if (instance == null) {
            instance = new Summary();
        }
        return instance;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        if (this.ready != ready) {
            boolean oldValue = this.ready;
            this.ready = ready;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_READY, oldValue, this.ready);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String name) {
        this.title = name;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public Category getCategory(String name) {
        Category category = null;
        if (name != null && this.categories != null) {
            for (Category c : this.categories) {
                if (!c.getName().equals(name)) continue;
                category = c;
                break;
            }
        }
        return category;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void addComponentSet(ComponentSet componentSet) {
        if (componentSet != null) {
            this.componentSets.add(componentSet);
        }
    }

    public ComponentSet getComponentSet(String name) {
        ComponentSet componentSet = null;
        if (name != null && this.componentSets != null) {
            for (ComponentSet set : this.componentSets) {
                if (!set.getName().equals(name)) continue;
                componentSet = set;
                break;
            }
        }
        return componentSet;
    }

    public List<ComponentSet> getComponentSets() {
        return this.componentSets;
    }

    public void setSuccessfullInstall(boolean isSuccessfullInstall) {
        this.isSuccessfullInstall = isSuccessfullInstall;
    }

    public boolean isSuccessfullInstall() {
        return this.isSuccessfullInstall;
    }

    public void setSuccessfulConfig(boolean isSuccessfulConfig) {
        this.isSuccessfulConfig = isSuccessfulConfig;
    }

    public boolean isSuccessfulConfig() {
        return this.isSuccessfulConfig;
    }

    public void setSuccessfullRemoteInstall(boolean isSuccessfullRemoteInstall) {
        this.isSuccessfullRemoteInstall = isSuccessfullRemoteInstall;
    }

    public boolean isSuccessfullRemoteInstall() {
        return this.isSuccessfullRemoteInstall;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public Document toXML() throws ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        document = docBuilder.newDocument();
        Element summaryTag = document.createElement("summary");
        summaryTag.setAttribute("name", this.getTitle());
        Element summaryDescriptionTag = document.createElement("description");
        CDATASection summaryCDATATag = document.createCDATASection(this.getDescription());
        summaryDescriptionTag.appendChild(summaryCDATATag);
        summaryTag.appendChild(summaryDescriptionTag);
        document.appendChild(summaryTag);
        Category category2 = null;
        ComponentSet componentSet2 = null;
        for (Category category2 : this.categories) {
            Element categoryTag = document.createElement("category");
            categoryTag.setAttribute("name", category2.getName());
            Element categoryDescriptionTag = document.createElement("description");
            CDATASection categoryCDATATag = document.createCDATASection(category2.getDescription());
            categoryDescriptionTag.appendChild(categoryCDATATag);
            categoryTag.appendChild(categoryDescriptionTag);
            for (Variable variable : category2.getVariables()) {
                Object value = variable.getValue();
                Element variableTag = document.createElement("variable");
                variableTag.setAttribute("name", variable.getName());
                Element variableDescriptionTag = document.createElement("description");
                CDATASection variableCDATATag = document.createCDATASection(variable.getDescription());
                variableDescriptionTag.appendChild(variableCDATATag);
                variableTag.appendChild(variableDescriptionTag);
                Element valueTag = null;
                if (value != null) {
                    if (value instanceof Percentage) {
                        Percentage percentage = (Percentage)value;
                        valueTag = document.createElement("percentage");
                        valueTag.setAttribute("value", String.valueOf(percentage.getPercentage()));
                        Element valueDescriptionTag = document.createElement("description");
                        String description = percentage.getDescription();
                        if (description != null) {
                            CDATASection cdataTag = document.createCDATASection(description);
                            valueDescriptionTag.appendChild(cdataTag);
                        }
                        valueTag.appendChild(valueDescriptionTag);
                    } else {
                        valueTag = document.createElement("value");
                        CDATASection cdataTag = document.createCDATASection(value.toString());
                        valueTag.appendChild(cdataTag);
                    }
                }
                if (valueTag != null) {
                    variableTag.appendChild(valueTag);
                }
                categoryTag.appendChild(variableTag);
            }
            summaryTag.appendChild(categoryTag);
        }
        for (ComponentSet componentSet2 : this.componentSets) {
            Element componentSetTag = document.createElement("components");
            componentSetTag.setAttribute("name", category2.getName());
            Element componentSetDescriptionTag = document.createElement("description");
            CDATASection componentSetCDATATag = document.createCDATASection(componentSet2.getDescription());
            componentSetDescriptionTag.appendChild(componentSetCDATATag);
            componentSetTag.appendChild(componentSetDescriptionTag);
            for (Component component : componentSet2.getComponents()) {
                Element componentTag = document.createElement("component");
                componentTag.setAttribute("name", component.getName());
                componentTag.setAttribute("version", component.getVersion());
                Element componentDescriptionTag = document.createElement("description");
                CDATASection componentCDATATag = document.createCDATASection(component.getName());
                componentDescriptionTag.appendChild(componentCDATATag);
                componentTag.appendChild(componentDescriptionTag);
                componentSetTag.appendChild(componentTag);
            }
            summaryTag.appendChild(componentSetTag);
        }
        return document;
    }

    public void beginUpdate() {
        this.setReady(false);
    }

    public void endUpdate() {
        this.setReady(true);
    }

    public void clear() {
        this.categories.clear();
        this.componentSets.clear();
    }
}

